/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_and_space.init;

import cofh.lib.common.block.OreBlockCoFH;
import java.util.Locale;
import java.util.Map;
import mrthomas20121.thermal_and_space.api.AstraStone;
import mrthomas20121.thermal_and_space.api.ThermalOre;
import mrthomas20121.thermal_and_space.util.Helpers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SpaceBlocks {
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thermal_and_space");
    public static DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"thermal_and_space");
    public static Map<AstraStone, Map<ThermalOre, RegistryObject<OreBlockCoFH>>> ORES = Helpers.mapOfKeys(AstraStone.class, stone -> Helpers.mapOfKeys(ThermalOre.class, ore -> SpaceBlocks.registerOre(ore.getOreName(stone.name().toLowerCase(Locale.ROOT)))));
    public static Map<AstraStone, RegistryObject<FallingBlock>> SAND_ORES = Helpers.mapOfKeys(AstraStone.class, AstraStone::isSand, stone -> SpaceBlocks.registerSandOre("oil_%s_sand".formatted(stone.name().toLowerCase(Locale.ROOT))));

    private static RegistryObject<FallingBlock> registerSandOre(String name) {
        RegistryObject block = BLOCKS.register(name, () -> new FallingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)));
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    private static RegistryObject<OreBlockCoFH> registerOre(String name) {
        RegistryObject block = BLOCKS.register(name, () -> new OreBlockCoFH(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60999_()));
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }
}

